package no.statkart.matrikkel.eksempel;


import no.statkart.matrikkel.matrikkelapi.wsapi.v1.service.adresse.AdresseService;
import no.statkart.matrikkel.matrikkelapi.wsapi.v1.service.adresse.AdresseServiceWS;
import no.statkart.matrikkel.matrikkelapi.wsapi.v1.service.bruker.BrukerService;
import no.statkart.matrikkel.matrikkelapi.wsapi.v1.service.bruker.BrukerServiceWS;
import no.statkart.matrikkel.matrikkelapi.wsapi.v1.service.bygning.BygningService;
import no.statkart.matrikkel.matrikkelapi.wsapi.v1.service.bygning.BygningServiceWS;
import no.statkart.matrikkel.matrikkelapi.wsapi.v1.service.forretning.ForretningService;
import no.statkart.matrikkel.matrikkelapi.wsapi.v1.service.forretning.ForretningServiceWS;
import no.statkart.matrikkel.matrikkelapi.wsapi.v1.service.grunnforurensing.GrunnforurensingService;
import no.statkart.matrikkel.matrikkelapi.wsapi.v1.service.grunnforurensing.GrunnforurensingServiceWS;
import no.statkart.matrikkel.matrikkelapi.wsapi.v1.service.kodeliste.KodelisteService;
import no.statkart.matrikkel.matrikkelapi.wsapi.v1.service.kodeliste.KodelisteServiceWS;
import no.statkart.matrikkel.matrikkelapi.wsapi.v1.service.kommune.KommuneService;
import no.statkart.matrikkel.matrikkelapi.wsapi.v1.service.kommune.KommuneServiceWS;
import no.statkart.matrikkel.matrikkelapi.wsapi.v1.service.kulturminne.KulturminneService;
import no.statkart.matrikkel.matrikkelapi.wsapi.v1.service.kulturminne.KulturminneServiceWS;
import no.statkart.matrikkel.matrikkelapi.wsapi.v1.service.matrikkelenhet.MatrikkelenhetService;
import no.statkart.matrikkel.matrikkelapi.wsapi.v1.service.matrikkelenhet.MatrikkelenhetServiceWS;
import no.statkart.matrikkel.matrikkelapi.wsapi.v1.service.matrikkelsok.MatrikkelsokService;
import no.statkart.matrikkel.matrikkelapi.wsapi.v1.service.matrikkelsok.MatrikkelsokServiceWS;
import no.statkart.matrikkel.matrikkelapi.wsapi.v1.service.person.PersonService;
import no.statkart.matrikkel.matrikkelapi.wsapi.v1.service.person.PersonServiceWS;
import no.statkart.matrikkel.matrikkelapi.wsapi.v1.service.rapport.RapportService;
import no.statkart.matrikkel.matrikkelapi.wsapi.v1.service.rapport.RapportServiceWS;
import no.statkart.matrikkel.matrikkelapi.wsapi.v1.service.sefrak.SefrakMinneService;
import no.statkart.matrikkel.matrikkelapi.wsapi.v1.service.sefrak.SefrakMinneServiceWS;
import no.statkart.matrikkel.matrikkelapi.wsapi.v1.service.store.StoreService;
import no.statkart.matrikkel.matrikkelapi.wsapi.v1.service.store.StoreServiceWS;

import jakarta.xml.ws.BindingProvider;
import jakarta.xml.ws.Service;
import jakarta.xml.ws.WebServiceFeature;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

/**
 * Initierer nye webservice objekter
 */
public class ServiceFactory {
    private final String SERVER_ADDRESS;
    private final String username, password;

    public ServiceFactory(String username, String password, String serverAddress) {
        this.SERVER_ADDRESS = serverAddress;
        this.username = username;
        this.password = password;
    }


    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Oppslag og Navigasjon
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


    private StoreService storeService;

    public StoreService storeService() {
        if (storeService == null) {
            storeService = createFor(StoreServiceWS.class);
        }
        return storeService;
    }

    private MatrikkelsokService matrikkelsokService;

    public MatrikkelsokService matrikkelsokService() {
        if (matrikkelsokService == null) {
            matrikkelsokService = createFor(MatrikkelsokServiceWS.class);
        }
        return matrikkelsokService;
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Tjenester
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    private AdresseService adresseService;

    public AdresseService adresseService() {
        if (adresseService == null) {
            adresseService = createFor(AdresseServiceWS.class);
        }
        return adresseService;
    }

    private BrukerService brukerService;

    public BrukerService brukerService() {
        if (brukerService == null) {
            brukerService = createFor(BrukerServiceWS.class);
        }
        return brukerService;
    }

    private BygningService bygningService;

    public BygningService bygningService() {
        if (bygningService == null) {
            bygningService = createFor(BygningServiceWS.class);
        }
        return bygningService;
    }

    private ForretningService forretningService;

    public ForretningService forretningService() {
        if (forretningService == null) {
            forretningService = createFor(ForretningServiceWS.class);
        }
        return forretningService;
    }

    private GrunnforurensingService grunnforurensingService;

    public GrunnforurensingService grunnforurensingService() {
        if (grunnforurensingService == null) {
            grunnforurensingService = createFor(GrunnforurensingServiceWS.class);
        }
        return grunnforurensingService;
    }

    private KodelisteService kodelisteService;

    public KodelisteService kodelisteService() {
        if (kodelisteService == null) {
            kodelisteService = createFor(KodelisteServiceWS.class);
        }
        return kodelisteService;
    }

    private KommuneService kommuneService;

    public KommuneService kommuneService() {
        if (kommuneService == null) {
            kommuneService = createFor(KommuneServiceWS.class);
        }
        return kommuneService;
    }

    private KulturminneService kulturminneService;

    public KulturminneService kulturminneService() {
        if (kulturminneService == null) {
            kulturminneService = createFor(KulturminneServiceWS.class);
        }
        return kulturminneService;
    }

    private MatrikkelenhetService matrikkelenhetService;

    public MatrikkelenhetService matrikkelenhetService() {
        if (matrikkelenhetService == null) {
            matrikkelenhetService = createFor(MatrikkelenhetServiceWS.class);
        }
        return matrikkelenhetService;
    }

    private PersonService personService;

    public PersonService personService() {
        if (personService == null) {
            personService = createFor(PersonServiceWS.class);
        }
        return personService;
    }

    private RapportService rapportService;

    public RapportService rapportService() {
        if (rapportService == null) {
            rapportService = createFor(RapportServiceWS.class);
        }
        return rapportService;
    }

    private SefrakMinneService sefrakMinneService;

    public SefrakMinneService sefrakMinneService() {
        if (sefrakMinneService == null) {
            sefrakMinneService = createFor(SefrakMinneServiceWS.class);
        }
        return sefrakMinneService;
    }


    private <S extends Service, P> P createFor(Class<S> clazz) {
        final String wsdlPath = String.format("WEB-INF/%s.wsdl", clazz.getSimpleName());
        final String endpointAddress = SERVER_ADDRESS + String.format("/matrikkelapi/wsapi/v1/%s", clazz.getSimpleName());
        final URL wsdlURL = ServiceFactory.class.getClassLoader().getResource(wsdlPath); //embedded wsdl schema

        final ArrayList<WebServiceFeature> features = new ArrayList<>();

        S service = buildService(clazz, wsdlURL);
        P port = buildPort(service, clazz, features);
        setServerAddress(port, endpointAddress);
        defineCredentials(port, username, password);
        return port;
    }


    static <P, S extends Service> P buildPort(S service, Class<S> clazz, List<WebServiceFeature> features) {
        String portName = clazz.getSimpleName().substring(0, clazz.getSimpleName().length() - 2);
        try {
            Object result = null;
            if (features.isEmpty()) {
                Method method = clazz.getDeclaredMethod(String.format("get%sPort", portName));
                result = method.invoke(service);
            } else {
                Method method = clazz.getDeclaredMethod(String.format("get%sPort", portName), WebServiceFeature[].class);
                result = method.invoke(service, new Object[]{
                        features.toArray(new WebServiceFeature[features.size()])
                });
            }
            return (P) result;
        } catch (NoSuchMethodException | InvocationTargetException | IllegalAccessException e) {
            throw new RuntimeException("Implementasjonsfeil i ws-klient", e);
        }
    }

    static <S extends Service> S buildService(Class<S> clazz, URL wsdlURL) {
        try {
            Constructor<S> constructor = clazz.getConstructor(URL.class);
            return constructor.newInstance(wsdlURL);
        } catch (NoSuchMethodException | InvocationTargetException | InstantiationException | IllegalAccessException e) {
            throw new RuntimeException("Implementasjonsfeil i ws-klient", e);
        }
    }

    static <P> void setServerAddress(P port, String endpointAddress) {
        BindingProvider bindingProvider = (BindingProvider) port;
        bindingProvider.getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, endpointAddress);
    }

    static <P> void defineCredentials(P port, String username, String password) {
        BindingProvider bindingProvider = (BindingProvider) port;
        bindingProvider.getRequestContext().put(BindingProvider.USERNAME_PROPERTY, username);
        bindingProvider.getRequestContext().put(BindingProvider.PASSWORD_PROPERTY, password);
    }

}
